//								EJEMPLO 14
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR0 en el modo contador de eventos externos
//
//Sobre el display 7 segmentos conectado a la puerta B se visualizar el nmero de pulsos 
//aplicados por RA4/T0CKI al TMR0, Cuando lleguen 6 pulsos se provoca una interrupcin 
//cuyo tratamiento activa todos los segmentos del display durante 1 seg. y luego se apagan. 
//Para repetir el proceso se debe accionar el pulsador de RESET

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)

#int_timer0
Tratamiento()		//Tratamiento para la interrupcin del TMR0
{	disable_interrupts(int_timer0);	//desconecta interrupcin del TMR0
	output_b(0xff);	//Activa todos los segmentos	
	delay_ms(1000);	//Temporiza 1 seg.
	output_b(0x00);	//Desactiva todos los segmentos
	sleep();		//Modo estandby
}
	
main()
{  
	unsigned int const display[16]={0x3F,0x06,0x5B,0x4F,// Al ser una tabla constante
                               0x66,0x6D,0x7D,0x07,		// se crea dentro de la memoria
                               0x7F,0x6F,0x77,0x7C,		// de programa.
                               0x39,0x5E,0x79,0x71};

	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	output_b (0x00);				//Borra las salidas
	
	setup_timer_0(RTCC_DIV_1|RTCC_EXT_L_TO_H);	//TMR0 reloj externo 0-1 y preescaler 1:1
	set_timer0 (~6);				//Carga el timer 0 con 6
	enable_interrupts(int_timer0);	//Habilita interrupcin del TMR0
	enable_interrupts(global);		//Habilita interrupciones

	while(1)
	output_b(display[~get_timer0()&0x0f]);	//Visualiza TMR0 sobre el display
}	
